<?php get_header(); ?>

	<div id="content" class="narrowcolumn">

	<?php if (have_posts()) : ?>

		<?php while (have_posts()) : the_post(); ?>

			<div class="post" id="post-<?php the_ID(); ?>">
                <div class="post-top">
                    <div class="post-date">
                        <?php the_time('M') ?>
                        <p><?php the_time('d') ?></p>
                    </div>
                    <div class="post-title">
                        <h2><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php if ( function_exists('the_title_attribute')) the_title_attribute(); else the_title(); ?>"><?php the_title(); ?></a></h2>
                        <h3>Автор: <span><?php the_author() ?></span>  |  Рубрика: <span><?php the_category(', ') ?></span>  |  <?php the_time('d M Y') ?>
                        </h3>
                    </div>
                </div>
                <div class="clear"></div>

				<div class="entry">
					<?php the_content('Читать полностью &raquo;'); ?>
				</div>

                <div class="postmetadata">
                    <div class="alignleft"><a class="readmore" href="<?php the_permalink() ?>" ><span>Постоянная ссылка</span></a></div>
                    <div class="alignright"><?php comments_popup_link('Отзывов <span>(0)</span>', 'Отзывов <span>(1)</span>', 'Отзывов <span>(%)</span>'); ?></div>
                	<div class="clear"></div>
                </div>
			</div>

		<?php endwhile; ?>

		<div class="navigation">
			<div class="alignleft"><?php next_posts_link('Предыдущая страница') ?></div>
			<div class="alignright"><?php previous_posts_link('Следующая страница') ?></div>
		</div>

	<?php else : ?>

		<h2 class="center">Не найдено</h2>
		<p class="center">К сожалению, по вашему запросу ничего не найдено.</p>
		<?php include (TEMPLATEPATH . "/searchform.php"); ?>

	<?php endif; ?>

	</div>

<?php get_footer(); ?>
